unit shandler;
{
/*
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is the Sablopas : Pascal wrapper for Sablotron.
 * More infos at http://www.tekool.com/sablopas - Contact : cespern@free.fr
 *
 * The Initial Developer of the Original Code is Christophe ESPERN
 * Portions created by Christophe ESPERN are Copyright (C) 2001-2002 Christophe
 * ESPERN. All Rights Reserved.
 *
 * Contributor(s):   None
}

interface

uses

 Sysutils
{$IFDEF WIN32}
 ,Windows
{$ENDIF}

 // For Kylix
{$IFDEF LINUX}
 {$IFNDEF FPC}
 ,Libc
 {$ENDIF}
{$ENDIF}
;
const
{$IFDEF LINUX}
 {$IFDEF FPC}
  {$LINKLIB c}
  {$LINKLIB expat}
 {$ENDIF}
 // Following are the names of the library file.
 // Change them if you fail to link or have an Expat loading error
 SAB_LIB='libsablot.so';
 EXPAT_LIB='libexpat.so';
{$ENDIF}
{$IFDEF WIN32}
 SAB_LIB='sablot.dll';
 EXPAT_LIB='expat.dll';
{$ENDIF}

const
  MH_LEVEL_DEBUG=0;
  MH_LEVEL_INFO=1;
  MH_LEVEL_WARN=2;
  MH_LEVEL_ERROR=3;
  MH_LEVEL_CRITICAL=4;

type

 SHandlerType=(
   HLR_MESSAGE,
   HLR_SCHEME,
   HLR_SAX,
   HLR_MISC,
   HLR_ENC
 );


 MH_LEVEL=LongWord;

 MH_ERROR=LongWord;

 SablotHandle=type LongWord;

 TSErrorFields=array [byte] of PChar;

 //************************* Message handler support ***********************************************

 SMessageHandlerError=procedure(userData:pointer;processor_:SablotHandle;code:MH_ERROR;level:MH_LEVEL;var fields:TSErrorFields);cdecl;
 SMessageHandlerMakeCode=procedure(userData:pointer;processor_:SablotHandle; severity,facility,code:integer);cdecl;
 SMessageHandlerLog=procedure(userData:pointer;processor_:SablotHandle;code:MH_ERROR;level:MH_LEVEL;var fields:TSErrorFields); cdecl;

 PSMessageHandlerError=^SMessageHandlerError;
 PSMessageHandlerLog=^SMessageHandlerLog;
 PSMessageHandlerMakeCode=^SMessageHandlerMakeCode;

 SMessageHandler=record
  makeCode:PSMessageHandlerMakeCode;
  log:PSMessageHandlerLog;
  error:PSMessageHandlerError;
 end;

 PSMessageHandler=^SMessageHandler;

 //************************* Scheme handler support ***********************************************

 SchemeHandlerGetAll=function (userData:pointer;processor_:SablotHandle;const scheme,rest:PCHar;var buffer:PChar;var byteCount:integer):integer;cdecl;
 SchemeHandlerFreeMemory=function (userData:pointer;processor_:SablotHandle;var buffer:PChar):integer;cdecl;
 SchemeHandlerOpen=function(userData:pointer;processor_:SablotHandle;const scheme,rest:PCHar;var handle:integer):integer;cdecl;
 SchemeHandlerGet=function(userData:pointer;processor_:SablotHandle;handle:integer;var buffer:PChar;var byteCount:integer):integer;cdecl;
 SchemeHandlerPut=function(userData:pointer;processor_:SablotHandle;handle:integer;const buffer:PChar;var byteCount:integer):integer;cdecl;
 SchemeHandlerClose=function(userData:pointer;processor_:SablotHandle;handle:integer):integer;cdecl;

 PSchemeHandlerGetAll=^SchemeHandlerGetAll;
 PSchemeHandlerFreeMemory=^SchemeHandlerFreeMemory;
 PSchemeHandlerOpen=^SchemeHandlerOpen;
 PSchemeHandlerGet=^SchemeHandlerGet;
 PSchemeHandlerPut=^SchemeHandlerPut;
 PSchemeHandlerClose=^SchemeHandlerClose;

 SSchemeHandler=record
    getAll:PSchemeHandlerGetAll;
    freeMemory:PSchemeHandlerFreeMemory;
    open:PSchemeHandlerOpen;
    get:PSchemeHandlerGet;
    put:PSchemeHandlerPut;
    close:PSchemeHandlerClose;
 end;

 PSSchemeHandler=^SSchemeHandler;

//************************* SAX handler support ***********************************************

  // Return type
 SAX_RETURN=type longword;

 // Attributes
 TSAtts=array[0..100] of PChar;

 // Functions
 SSAXHandlerStartDocument=function(userData:pointer; processor_:SablotHandle):SAX_RETURN;cdecl;
 SSAXHandlerStartElement=function(userData:pointer; processor_:SablotHandle; const name:PChar; const atts:TSAtts):SAX_RETURN;cdecl; // atts is wrong!!!
 SSAXHandlerEndElement=function(userData:pointer; processor_:SablotHandle; const name:PChar):SAX_RETURN;cdecl;
 SSAXHandlerStartNamespace=function(userData:pointer; processor_:SablotHandle; const prefix,uri:PChar):SAX_RETURN;cdecl;
 SSAXHandlerEndNamespace=function(userData:pointer; processor_:SablotHandle; const prefix:PChar):SAX_RETURN;cdecl;
 SSAXHandlerComment=function(userData:pointer; processor_:SablotHandle; const contents:PChar):SAX_RETURN;cdecl;
 SSAXHandlerPI=function(userData:pointer; processor_:SablotHandle; const target,contents:PChar):SAX_RETURN;cdecl;
 SSAXHandlerCharacters=function(userData:pointer; processor_:SablotHandle; const contents:PChar;length:integer):SAX_RETURN;cdecl;
 SSAXHandlerEndDocument=function(userData:pointer; processor_:SablotHandle):SAX_RETURN;cdecl;

 // Pointers
 PSAXHandlerStartDocument=^SSAXHandlerStartDocument;
 PSAXHandlerStartElement=^SSAXHandlerStartElement;
 PSAXHandlerEndElement=^SSAXHandlerEndElement;
 PSAXHandlerStartNamespace=^SSAXHandlerStartNamespace;
 PSAXHandlerEndNamespace=^SSAXHandlerEndNamespace;
 PSAXHandlerComment=^SSAXHandlerComment;
 PSAXHandlerPI=^SSAXHandlerPI;
 PSAXHandlerCharacters=^SSAXHandlerCharacters;
 PSAXHandlerEndDocument=^SSAXHandlerEndDocument;

 // SAX Handler record
 SSAXHandler=record
   StartDocument:PSAXHandlerStartDocument;
   StartElement:PSAXHandlerStartElement;
   EndElement:PSAXHandlerEndElement;
   StartNamespace:PSAXHandlerStartNamespace;
   EndNamespace:PSAXHandlerEndNamespace;
   Comment:PSAXHandlerComment;
   PI:PSAXHandlerPI;
   Characters:PSAXHandlerCharacters;
   EndDocument:PSAXHandlerEndDocument;
 end;

 PSSAXHandler=^SSAXHandler;

//For Kylix
var
 ExpatHdl:Pointer;
implementation
{$IFDEF LINUX}
 {$IFNDEF FPC}
 initialization
  ExpatHdl := Libc.dlopen(EXPAT_LIB,RTLD_LAZY or RTLD_GLOBAL);
  if ExpatHdl=nil then
   raise Exception.create('SHandler.pas - Expat loading error')
 finalization
  if ExpatHdl<>nil then
   Libc.dlclose(ExpatHdl);
 {$ENDIF}
{$ENDIF}
end.


